class: center, middle
![Logo](logo.png)
# Hygiène numérique pour<br/>l’administrateur système

@aeris, 13 mai 2017

![Licence CC-BY-NC-SA](licence.png)

---
# Aeris
### Groupe cyber-terroriste individuel auto-radicalisé sur Internet

<table><tr><td style="vertical-align: top; text-align: left;">

Mail / Jabber : [aeris@imirhil.fr](mailto:aeris@imirhil.fr)  
Mastodon : [aeris@social.imirhil.fr](https://social.imirhil.fr/@aeris)

Blog : https://blog.imirhil.fr/  
Conférences : https://confs.imirhil.fr/

GPG : EFB7 4277 ECE4 E222  
OTR : 5769 616D 2D3D AC72

</td><td style="vertical-align: top; text-align: center;">

![Café Vie Privée](cvp.png)
![The Tor Project](tor.png)

</td><td style="vertical-align: top; text-align: right;">

Devops chez [Cozy Cloud](https://cozy.io/)
![Cozy Cloud](cozy.png)

</td></tr></table>

---
# Sommaire

* <span class="alert">⚠️ Disclaimer ⚠️</span>

* Installation de l’OS

* Config minimale

* Applicatifs

* Les nouveaux dangers

* TLS

* Questions

---
<h1 class="alert">⚠️ Disclaimer ⚠️</h1>

> La sécurité est un processus, pas un produit<br/>
> — <cite>Bruce Schneier</cite>

--

\#define MODÈLE_DE_MENACE
 * NSA, système de sauvegarde mondial ?
 * Miroslav, cybercriminel russe ?
 * MIRAI, logiciel digital ?
 * Kévin, script kiddie ?
 * Marcel, votre boss ?
 * Marion, votre collègue ?

--

Adapter à **vos** besoins et **vos** contextes

* Le code de l’arme nucléaire US de 1963 à 2004 ?
--
&nbsp;00 00 00 00

???
Il fallait agir vite, ne pas perdre les codes, etc.

---
<h1 class="alert">⚠️ Disclaimer ⚠️</h1>

Ici, on considèrera :

* une sécurité « standard »
* pour un admin sys « standard »
* dans un contexte « standard »

On va parler uniquement **InfoSec** et pas du tout **OpSec**

Si vous avez des besoins spécifiques :

* Electronic Frontier Foundation
* Café vie privée
* Reporters sans Frontière

---
class: center, middle
# Installation de l’OS

---
# Choix de l’OS (1/)

On parle de serveurs, donc :

* Un système stable

	* Du **GNU/Linux** ou du **\*BSD**

	* Éviter les rolling-release (Gentoo, Arch…)

	* Éviter les distribs « kleenex » entre 2 versions (Ubuntu…)

--
* Un système **standard**

	* L’exotisme, c’est bien pour les vacances seulement (Alpine…)

--
* Un système **à jour en terme de sécurité**

	* Les LTS ne sont bizarrement pas forcément l’idéal

	* Surtout sur la fin

---
# Choix de l’OS (2/)

![Debian](debian.png)
![FreeBSD](freebsd.png)
![CentOS](centos.png)
![RedHat](redhat.png)

(Pour la suite, on va essentiellement parler Debian)

---
# Installation de l’OS (1/)

* Installez **vous-même** (pas d’installeur OVH/Online)

	* Ça évite d’avoir n’importe quoi à la fin
	* On maîtrise ce qu’on installe (`~/.p` chez OVH)

--
* N’hésitez pas à passer en mode ***expert***

	* Évite d’installer des choses inutiles  
	Debian « next/next/next » : 925Mo, 480 paquets  
	Debian « manuelle » : 625Mo, 248 paquets  
	Debian « minimale » : 194Mo, 163 paquets

--
* Désactivez l’installation des ***recommends*** et des ***suggests***

	* Évite d’installer des choses inutiles aussi

```bash
/etc/apt/apt.conf.d/60recommends
APT::Install-Recommends "0";
APT::Install-Suggests "0";
```
---
# Installation de l’OS (2/)

Chiffrement ou pas **chiffrement des disques** ?

* Pour un **serveur** : bof

	* FDE difficile (problème du boot)
	* Ne protège que d’une saisie (offline), aucune utilité online
	* Limiter le chiffrement au strict nécessaire

* Pour une **machine utilisateur** : <span class="alert">obligatoire !</span>

	* Protection contre le vol/la perte
	* On éteint la machine !

* Dans tous les cas, privilégier ***LUKS on LVM***

	* Chiffrement intégral du disque (peu de métadonnées)
	* Une seule phrase de passe même si plusieurs partitions
	* Plus modulable


---
# Installation de l’OS (3/)

* Activez les **mises-à-jour de sécurité et de publication**

```bash
/etc/apt/sources.list.d/debian.list
deb http://deb.debian.org/debian/ jessie main
deb http://deb.debian.org/debian/ jessie-updates main
deb http://deb.debian.org/debian-security/ jessie/updates main
```

* Inscrivez-vous auprès de la **liste de diffusion des alertes de sécurité**

https://lists.debian.org/debian-security-announce/

---
class: center, middle
# Sécurisation minimale

---
# Sécurisation minimale (1/)


* Installez un **firewall**

	* *iptables* fait bien le boulot

	* Par défaut, on rejette tout le trafic entrant

	* On ne laisse passer explicitement que ce dont on a réellement besoin
		* HTTP (80), HTTPS (443), SSH (22/XXXX), mail (25/587/993)…

--
* L’ennemi est dorénavant **dans votre réseau**
 
	* Internet of shit (imprimantes, caméras, frigos, dildos…)

	* Mobilité (débilephones, ami à la maison…)


---
```bash
iptables-save -t filter
*filter
:INPUT DROP
:FORWARD DROP
:OUTPUT DROP

# Windows, ça spam…
-A INPUT -p udp -d 255.255.255.255 -j DROP
-A INPUT -p udp -d X.X.X.255 -j DROP
-A INPUT -p udp -m multiport --dport netbios-ns,netbios-dgm,netbios-ssn -j DROP

-A INPUT -i lo -j ACCEPT
-A INPUT -p icmp -j ACCEPT
-A INPUT -m conntrack --ctstate RELATED,ESTABLISHED -j ACCEPT
-A INPUT -p tcp -m tcp --dport ssh -j ACCEPT
-A INPUT -p tcp -m tcp --dport http -j ACCEPT
-A INPUT -p tcp -m tcp --dport https -j ACCEPT
-A INPUT -p tcp -m tcp --dport smtp -j ACCEPT
-A INPUT -p tcp -m tcp --dport submission -j ACCEPT
-A INPUT -p tcp -m tcp --dport imaps -j ACCEPT

-A OUTPUT -o lo -j ACCEPT
-A OUTPUT -p icmp -j ACCEPT
-A OUTPUT -m conntrack --ctstate NEW,RELATED,ESTABLISHED -j ACCEPT

COMMIT
```

---
# Sécurisation minimale (3/)

* On désactive les **connexions par mot de passe** de SSH

	* Clef SSH only

	* Suffisamment robuste (RSA > 3072 bits ou ED25519 ❤️)

	* On en profite pour désactiver les vieux algos

	* Et pour changer le port par défaut

 		* Ça n’évitera pas les attaques, mais au moins celles de Kévin

		* Ça nettoie sérieusement les logs

---
# Sécurisation minimale (4/)
```bash
/etc/ssh/sshd_config
Port XXXX

#HostKey /etc/ssh/ssh_host_rsa_key
#HostKey /etc/ssh/ssh_host_dsa_key
#HostKey /etc/ssh/ssh_host_ecdsa_key
HostKey /etc/ssh/ssh_host_ed25519_key

PermitRootLogin prohibit-password
PasswordAuthentication no

Ciphers chacha20-poly1305@openssh.com
KexAlgorithms curve25519-sha256@libssh.org
MACs umac-128-etm@openssh.com
```

---
# Sécurisation minimale (5/)

* Activer la 2FA sur SSH (au moins pour `root`)

	* `apt install libpam-yubico`

	* https://developers.yubico.com/yubico-pam/
	* https://developers.yubico.com/yubico-pam/Yubikey_and_SSH_via_PAM.html

---
# Sécurisation minimale (6/)

* Installation de ***failban***

	* Bloque les ports via *iptables* en cas de bruteforce
	
	* SSH — SMTP/IMAP — HTTP
	
	* Pas la panacée mais ça nettoie les logs (Kévin…)
	
	* Gaffe à ne pas s’auto-bannir !


---
# Sécurisation minimale (7/)

* Activation des **mises-à-jour de sécurité automatique**

	* Paquet *unattended-upgrades* + un peu de configuration  
		https://wiki.debian.org/UnattendedUpgrades

	* Ça n’empèche certainement pas de passer sur sa machine régulièrement

	* Au moins pour redémarrer les services

---
# Un peu de réseau (1/)

* Vérifier la source (*UDP spoofing*)
```bash
sysctl -w net.ipv4.conf.default.rp_filter = 1
```
--
* Activer les SYN cookies (limite le *SYN flooding*)
```bash
sysctl -w net.ipv4.tcp_syncookies = 1
```
--
* Rejeter les redirections ICMP (limite les MitM)
```bash
sysctl -w net.ipv4.conf.all.accept_redirects = 0
sysctl -w net.ipv4.conf.all.secure_redirects = 0
```
--
* Désactiver le *source routing*  
```bash
sysctl -w net.ipv4.conf.default.accept_source_route = 0
```

---
class: center, middle
# Applicatif

---
# DNS

* Éviter les serveurs faisant autorité en tant que résolveur

	* DNS poisonning = export à l’extérieur… 

	* Donc pas de *bind9*
	
	* Plutôt ***unbound*** ou ***knot***
	
	* Activer ***DNSSec*** (généralement par défaut)

	* Pour du cache, envisager un forward de confiance
	
		* ns0.fdn.org / ns1.fdn.org
		* ns0.ldn-fai.net

---
```bash
$ dig imirhil.fr

; <<>> DiG 9.10.3-P4-Debian <<>> imirhil.fr
;; global options: +cmd
;; Got answer:
;; ->>HEADER<<- opcode: QUERY, status: NOERROR, id: 9872
*;; flags: qr rd ra ad; QUERY: 1, ANSWER: 1, AUTHORITY: 3, ADDITIONAL: 3

;; OPT PSEUDOSECTION:
; EDNS: version: 0, flags:; udp: 4096
;; QUESTION SECTION:
;imirhil.fr.                    IN      A

;; ANSWER SECTION:
imirhil.fr.             3600    IN      A       62.210.124.124

;; AUTHORITY SECTION:
imirhil.fr.             604800  IN      NS      ns.imirhil.fr.
imirhil.fr.             604800  IN      NS      nssec.online.net.
imirhil.fr.             604800  IN      NS      primary.heberge.info.

;; ADDITIONAL SECTION:
ns.imirhil.fr.          555172  IN      A       62.210.124.124
ns.imirhil.fr.          555172  IN      AAAA    2001:bc8:3f23:100::1

;; Query time: 37 msec
;; SERVER: 127.0.0.1#53(127.0.0.1)
;; WHEN: Mon Apr 03 23:56:24 CEST 2017
;; MSG SIZE  rcvd: 180
```

---
# TLS (1/trop)

* Très dépendant des logiciels niveau config

* TL;DR : **<span class="success">TLSv1.2 + ECDHE+AES (+ ECDHE+CHACHA20+POLY1305)</span>**

	* TLS<v1.2 = CBC padding attack, POODLE
	* Pas de PFS, pas de chocolat
	* DHE = lent, risqué (génération des clefs), mitm ☢️
	* RC4 backdooré / 3DES faillible à sweet32
	* Le reste on n’en parle même pas (EXPORT, DES, NULL, ANONYMOUS…)
	* Taille de clef >3072 bits pour RSA (4096 bits en pratique)
	* SHA-1 pas un problème (utilisé pour du MAC) et en même temps un problème (authentification)

* Si compatibilité nécessaire, TLSv1.1 mais avec EtM

	* POODLE si pas de support client

---
# HTTPD (1/)

* Masquer le n° de version, l’OS…

```bash
# apache
ServerTokens Prod
ServerSignature Off
# nginx
server_tokens off;
```

* Désactiver *mod_status*

```bash
a2dismod status && systemctl apache2 restart
```

* Désactiver le listing des répertoires

```bash
# apache
Options -Indexes
# nginx
# Par défaut (autoindex on;)
```

---
# HTTPD (2/)

* **HTTPS** partout, activer **HSTS**

	* Let's Encrypt — https://hstspreload.org/
	
```bash
Strict-Transport-Security "max-age=31536000; includeSubDomains; preload"
```

* Activer les ***Content Security Policy***

	* Minimisation des droits (idéalement *none* ou *self*)
	* On évite les *inline*

```bash
Content-Security-Policy "default-src 'none'; style-src 'self';
			script-src 'self'; img-src 'self';"
```

* D’autres en-têtes de sécurité

```bash
X-Content-Type-Options "nosniff"
X-Frame-Options "DENY"
X-XSS-Protection "1; mode=block"
```

---
# SMTP / IMAPS / Submission

* Ne pas utiliser le port *SMTP* (25) pour l’envoi, mais ***Submission*** (587)

	* 25 (STARTTLS) = non authentifié, entrant only, anti-spam, greylist…
	* 587 (TLS) = authentifié, open bar

* ***Greylisting*** (*postgrey*)

* ***Antispam*** (*amavis*, *spamassassin*… Bon courage…)

* ***SPF*** & ***DKIM*** (*opendkim*)

	* (*DMARC* casse toute liste de diffusion)

* Bien vérifier qu’on n’est pas un **relai ouvert**

	* https://mxtoolbox.com/diagnostic.aspx
	* http://www.mailradar.com/openrelay/

* ***postfix*** + ***dovecot*** 💘

---
class: center, middle
# Les nouveaux dangers

---
# ZMap / Scans.io / Shodan (1/)

[ZMap](https://zmap.io/) / [Scans.io](https://scans.io/) / [Shodan](https://www.shodan.io/)

Scan **TOUT** IPv4 chaque jour (ou presque)

Open-data sur les données

API accessibles

<br/>
--

Système en ligne = ETA exposition publique < 48h

--

0day ou faille = ETA exploitation < 48h

---
![Shodan](shodan-2.png)

---
![Shodan](shodan-3.png)

---
![Shodan](shodan-1.png)

---
![Shodan](shodan-4.png)

---
![Shodan](shodan-5.png)

---
# ZMap / Scans.io / Shodan (3/)

Parade :

* Contenu vierge sur le vhost par défaut

* Pas de SAN sur TLS

---
# Certificate Transparency (CT)

[crt.sh](https://crt.sh/) :
base de données *append-only* des émissions de certificats

![crt.sh](crt-sh.png)

---
# Certificate Transparency (CT)

Parade :

* ~~Ne pas utiliser de CA *CT-aware*~~

* Utiliser une CA personnelle pour les choses critiques

---
# Docker / Snap / Go

Tendance au « tout packagé »

* Trucs exotiques (Alpine…)

* Transforme le développeur en mainteneur

* YOLO BYIE 
--
(You Only Live Once, But You Infect Everybody)

---
![Discourse Docker](docker-discourse.png)
<br/><br/>
--
<span class="alert">Version/intégrité ? `/tmp` (ugo=rwX+t) ? `make install` ? `apt install/hold` ?</span>

---
# Docker / Snap / Go

Besoin d’isoler une application : LXC


--
⚠️ Conteneurisation : <span class="alert">pas d’isolation</span>

Une appli root du conteneur qui s’échappe = un attaquant root sur la machine physique


--
Si multi-tenant, virtualisation lourde obligatoire
(Xen, Qemu/KVM, VirtualBox, VMWare…)

---
class: center, middle
# X.509 / TLS

---
# X.509 et le problème des CA

* Contexte de moins en moins *safe*

	* Mobilité : wifi public, 3G/4G

	* FAI : mitm, dns spoof…
		* Bouygues Télécom
		* SFR

	* Compromission des CA
		* StartSSL / WoSign : 2.000 *mis-issued*
		* Symantec : 300.000 *mis-issued*
		* Symantec & BlueCoat
		* Let's Encrypt : « Paypal »
	
--

<p class="alert">Le système des CA a vécu…</p>
Nécessité de remettre l’administrateur au cœur du cercle de confiance

---
# HTTP Public Key Pinning (HPKP)

Déclare dans les en-têtes HTTP des épingles à vérifier à la prochaine visite

```
$ curl -sI https://imirhil.fr/ | grep public-key-pins
public-key-pins: max-age=5184000;
	pin-sha256="wdkD38iQQzxE7g0RpmN8VoaIqX7YmPWwoueD9Iqawfg=";
	pin-sha256="grcO0hHONi6YWf7AUdq1kPpDIVx6FIsKHLI3UugAhug="
```

On peut épingler :
* La racine : protège de l’émission d’un certificat par une autre CA
* L’intermédiaire : bof + risque de changement (Let's Encrypt)
* La feuille : peut être galère en cas de CDN

--

Épingle de secours obligatoire

<div class="alert">

Une fois déployé, **beaucoup** réfléchir avant toute modification  
Config cassée = anciens visiteurs KO durant **max-age**

</div>

---

# DANE/TLSA (2/)

* Nécessite DNSSec 😢

* Double chaîne de certification

	* Applicatif (HTTP, XMPP, SMTP…)

	* DNS

--

* Aucun intérêt si clefs sur machine applicative

	* applicatif powned ⇒ DNSSec powned ⇒ TLSA powned

--

	* stealth master DNS


--

* OpenDNSSec

	* https://www.octopuce.fr/documentation-interne-a-octopuce-sur-dnssec/

---
# Questions ?
